waste_dict = {
    "可回收物": ['纸箱', '旧书本', '玻璃瓶', '旧衣物', '易拉罐', '金属餐具'],
    '厨余垃圾': ['菜叶果皮', '剩饭剩菜', '茶叶渣', '蛋壳', '花卉绿植', '宠物饲料'],  # 修正笔误：宠物饮料→宠物饲料
    '其他垃圾': ['塑料袋', '毛发', '橡皮泥', '文具', '猫砂', '一次性餐具', '纸尿裤'],
    '有害垃圾': ['电池', '杀虫剂', '荧光灯管', '过期药品', '染发剂罐', '废打印机墨盒', 'X光片']  # 移除X光片空格
}

print("□欢迎使用垃圾分类查询系统")
print("=" * 40)
print("提示:输入垃圾名称查询分类,输入 q 退出程序\n")

while True:
    item = input("请输入垃圾名称:").strip()  # 添加strip()移除空格

    # 退出检测（修正缩进）
    if item.lower() == 'q':
        print("\n感谢使用,环保从你我做起!")
        break

    # 初始化查找状态
    found = False

    # 遍历所有分类进行搜索（修正缩进）
    for category, items in waste_dict.items():
        if item in items:
            print(f"\n查询结果:{item} → {category}")
            print("-" * 40)
            found = True
            break

    # 未找到处理（修正缩进和逻辑）
    if not found:
        print("\n未找到该物品的分类,请自行判断,或联系当地环保部门确认。")
        print("=" * 40)